from OfficeOpenXml import *
from OfficeOpenXml.ConditionalFormatting import *
from OfficeOpenXml.Style import *
from MS2Go.Core.Proteomics.AminoAcids import *
from MS2Go.Core.Processors import DetectionType
from System import *
from System.IO import *
from System.Collections import *
from System.Drawing import *
#from System import Array
import operator

configuration = dataprovider['configuration']
dataprovider['tmt'] = any(dataprovider.GetData('AnalysisDefinition').StudyDefinition.QuanMethods)

defaultColor = Color.FromArgb(231, 230, 230)
sampleColor1 = Color.FromArgb(255, 222, 157)
sampleColor2 = Color.FromArgb(255, 201, 157)
annotationColor1 = None
annotationColor2 = None

colorMin = Color.Red
colorMid = Color.Yellow
colorMax = Color.FromArgb(146, 208, 80)

colorUp = Color.FromArgb(248, 105, 107)
colorDown = Color.FromArgb(90, 138, 198)

class Iterator:
	def __init__(self, *items):
		self.items = items
		self.reset()
	def reset(self):
		self.current = None
		self.index = 0
	def next(self):
		self.current = self.items[self.index]
		self.index = (self.index + 1) % len(self.items)
		return self.current

sampleIterator = Iterator(sampleColor1, sampleColor2)

# range functions --------------------------------------------------
def formatSheet():
	context.Worksheet.Cells.Style.Font.Name = "Tahoma"
	context.Worksheet.Cells.Style.Font.Size = 10
	context.TitleRange.Style.Font.Size = 12
	context.TitleRange.Style.Font.Bold = True
	sampleIterator.reset()
	
	if context.HeaderRange:
		fill(context.HeaderRange, defaultColor)
		align(context.HeaderRange, 'Center', 'Center')
		context.Worksheet.Cells[context.HeaderRange.End.Row, context.HeaderRange.Start.Column, context.HeaderRange.End.Row, context.HeaderRange.End.Column].AutoFilter = True
		context.HeaderRange.Style.Border.Top.Style = ExcelBorderStyle.Thin
		context.HeaderRange.Style.Border.Bottom.Style = ExcelBorderStyle.Thin
		context.HeaderRange.Style.Border.Left.Style = ExcelBorderStyle.Thin
		context.HeaderRange.Style.Border.Right.Style = ExcelBorderStyle.Thin

def formatSampleMap():
	fill(context.HeaderRange, sampleIterator.next())
	group(context.Row, 1)
	
	if not dataprovider['isTMT']:
		size(w=4, h=200)
		context.HeaderRange.Style.TextRotation = 180
	
	context.DataRange.Style.Font.Name = 'Wingdings'
	context.DataRange.Style.HorizontalAlignment = ExcelHorizontalAlignment.Center
	context.PostProcessing += lambda c: c.Column.AutoFit()

def formatColumn(format = None, width = None, level=None):
	context.TitleRange.Style.HorizontalAlignment = ExcelHorizontalAlignment.Center
	context.Column.AutoFit()
	if format:
		context.Column.Style.Numberformat.Format = format
		context.DataRange.Style.HorizontalAlignment = ExcelHorizontalAlignment.Center
	if width:
		context.Column.AutoFit(0, width)
	else:
		context.Column.AutoFit()
	if level:
		group(context.Column, level)

def size(w = None, h = 0):
	if w:
		context.Column.Width = w
	if h:
		context.Row.Height = h

def align(range, h = None, v = None):
	if h:
		h = Enum.Parse(ExcelHorizontalAlignment, h)
		range.Style.HorizontalAlignment = h
	if v:
		v = Enum.Parse(ExcelVerticalAlignment, v)
		range.Style.VerticalAlignment = v

def fill(range, color):
	range.Style.Fill.PatternType = ExcelFillStyle.Solid
	range.Style.Fill.BackgroundColor.SetColor(color)

def group(item, level):
	item.OutlineLevel = level
	item.Collapsed = True

def formatThreeColorScale(min, mid, max):
	scale = context.DataRange.ConditionalFormatting.AddThreeColorScale()
	scale.LowValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.LowValue.Color = colorMin
	scale.LowValue.Value = min
	scale.MiddleValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.MiddleValue.Color = colorMid
	scale.MiddleValue.Value = mid
	scale.HighValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.HighValue.Color = colorMax
	scale.HighValue.Value = max

def formatCoverageScale():
	bar = context.DataRange.ConditionalFormatting.AddDatabar(Color.FromArgb(100, 149, 237))
	bar.LowValue.Type = eExcelConditionalFormattingValueObjectType.Num
	bar.LowValue.Value = 0
	bar.HighValue.Type = eExcelConditionalFormattingValueObjectType.Num
	bar.HighValue.Value = 1

def formatRatioScale():
	scale = context.DataRange.ConditionalFormatting.AddThreeColorScale()
	scale.LowValue.Type = eExcelConditionalFormattingValueObjectType.Min
	scale.LowValue.Color = Color.FromArgb(90, 138, 198)
	scale.MiddleValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.MiddleValue.Color = Color.White
	scale.MiddleValue.Value = 1
	scale.HighValue.Type = eExcelConditionalFormattingValueObjectType.Max
	scale.HighValue.Color = Color.FromArgb(248, 105, 107)

def formatLogRatioScale():
	scale = context.DataRange.ConditionalFormatting.AddThreeColorScale()
	scale.LowValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.LowValue.Color = Color.FromArgb(90, 138, 198)
	scale.LowValue.Value = -2
	scale.MiddleValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.MiddleValue.Color = Color.White
	scale.MiddleValue.Value = 0
	scale.HighValue.Type = eExcelConditionalFormattingValueObjectType.Num
	scale.HighValue.Color = Color.FromArgb(248, 105, 107)
	scale.HighValue.Value = 2

# cell functions --------------------------------------------------
def valueFromColumn(c):
	c.Value = c.Value[c.ColumnItem] if c.ColumnItem in c.Value and c.Value[c.ColumnItem] else None

def valueFromColumnKey(c):
	altKey = '{}.raw'.format(c.ColumnItem.Key)
	if c.Value:
		if c.ColumnItem.Key in c.Value:
			c.Value = c.Value[c.ColumnItem.Key]
		elif altKey in c.Value:
			c.Value = c.Value[altKey]
		else:
			c.Value = None
	
	#c.Value = c.Value[c.ColumnItem.Key] if c.Value and c.ColumnItem.Key in c.Value else None
	#c.Value = getattr(c.Value, c.ColumnItem.Key, None)

def valueFromColumnName(c):
	c.Value = c.Value[c.ColumnItem.Name] if c.Value and c.ColumnItem.Name in c.Value else None

def valueFromCount(c):
	c.Value = len(c.Value)

def valueFromSampleName(c):
	key = c.ColumnItem.SampleInfos[0].Key
	c.Value = c.Value[key] if c.Value and key in c.Value else None

def markX(c):
	c.Value = 'ü' if c.Value else None

def hideZeros(c):
	if not c.Value:
		c.Value = None

def autoFit(c):
	c.Column.AutoFit()

def fillContaminant(c):
	if c.RowItem.Contaminant:
		fill(c.Row, Color.FromArgb(234, 206, 206))

def hyperlinkAccession(c):
	if not getattr(context.RowItem, 'Contaminant', False):
		accession = context.RowItem.Accession
		if context.Value.startswith("FBpp"):
			url = "http://flybase.org/reports/"
		elif context.Value.startswith("Y"):
			url = "https://www.yeastgenome.org/locus/"
		elif context.Value.startswith("ENSDARP"):
			url = "http://www.ensembl.org/Danio_rerio/Transcript/Sequence_Protein?t="
		elif context.Value.startswith('AT'):
			url = "http://www.arabidopsis.org/servlets/TairObject?type=gene&amp;name="
		else:
			url = "https://www.uniprot.org/uniprot/";
			accession = accession.split('.')[0]
		
		context.ValueRange.Hyperlink = ExcelHyperLink(url + accession)
		context.ValueRange.Style.Font.Color.SetColor(Color.Blue)
		context.ValueRange.Style.Font.UnderLine = True

def getMasterProteins(c):
	return list(filter(lambda p: p.IsMasterProtein == 'Master', c.Value))

def concatAccessions(c):
	c.Value = '; '.join(map(lambda p: p.Accession, c.Value))

def concatDescriptions(c):
	c.Value = ' | '.join(map(lambda p: p.Description, c.Value))

def formatSequence(c):
	for segment in c.Value:
		text = segment.Acids
		if segment.Flag == AAFlag.ModifiedLow:
			text = text.ToLower()
		rt = c.ValueRange.RichText.Add(text)
		rt.FontName = "Courier New"
		rt.Size = 8
		
		if segment.Flag == AAFlag.ModifiedHigh or segment.Flag == AAFlag.ModifiedLow:
			rt.Color = Color.Red
		elif segment.Flag == AAFlag.Covered:
			rt.Color = Color.Green
		else:
			rt.Color = Color.Black
	c.Value = None

def getPositionsText(c):
	c.Value = '; '.join(map(lambda i: ','.join(map(lambda p: str(p + 1).zfill(5), i.Positions)), c.Value))