libPath <- "C:\\temp\\MS2Go\\lib"
dir.create("C:\\temp"); dir.create("C:\\temp\\MS2Go"); dir.create(libPath)
.libPaths(libPath)
update.packages(lib.loc=libPath, repos="https://cran.wu.ac.at", ask=FALSE)
if (!require(RSQLite)) {
	install.packages("RSQLite", repos="https://cran.wu.ac.at", lib=libPath)
}
require(RSQLite, lib=libPath)

if (!require(mcga)) {
	install.packages("mcga", repos="https://cran.wu.ac.at", lib=libPath)
}
require(mcga, lib=libPath)


if (!require(dendextend)) {
	install.packages("dendextend", repos="https://cran.wu.ac.at", lib=libPath)
}
deInst <- require(dendextend, lib=libPath)

if (!require(psych)) {
	install.packages("psych", repos="https://cran.wu.ac.at", lib=libPath)
}
require(psych, lib=libPath)


qcPlots <- function(pdResFile, pngFileName, filterName, sampleOrder=c()) {
	vars <- sort(ls(globalenv()))

	try(pdResConn <- dbConnect(SQLite(), pdResFile))
	try(system.time(psms <- dbGetQuery(pdResConn, "SELECT * FROM TargetPsms;")))
	try(pdResViewConn <- dbConnect(SQLite(), gsub(".pdResult", ".pdResultView", pdResFile, fixed=TRUE)))
	try(system.time(filteredPsms <- dbGetQuery(pdResViewConn, paste("SELECT * FROM ", filterName, ";", sep=""))))
	try(psms <- merge(x=psms, y=filteredPsms, by=c("WorkflowID", "PeptideID"), all.y=TRUE))
	
	if (nrow(psms)<1) {
		png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_1.png", sep=""), width=1400, height=500)
		plot(0, bty="n", xaxt="n", yaxt="n", xlab="", ylab="", type="n")
		text(1, 0, "no PSMS checked", col="red", cex=3)
		dev.off()
		return(0)
	}

	# numericColumns <- c("X..Proteins", "X..Protein.Groups", "X.Score", "X.Cn", "Rank", "Search.Engine.Rank", "QuanResultID", "Precursor.Area", "q.Value", "PEP", "IonScore", "Exp.Value", "MissedCleavages", "Isolation.Interference....", "Ion.Inject.Time..ms.", "Charge", "m.z..Da.", "MH...Da.", "DeltaMassInPPM", "RT..min.", "First.Scan", "Last.Scan")
	numericColumns <- c("DeltaCn", "Rank", "SearchEngineRank", "MissedCleavages", "IonInjectTime", "Charge", "MassOverCharge", "Mass", "DeltaMassInPPM", "RetentionTime", "FirstScan", "LastScan")
	psms[,colnames(psms) %in% numericColumns] <- apply(psms[,colnames(psms) %in% numericColumns, drop=FALSE], 2, as.numeric)

	if (!c("Annotated.Sequence") %in% colnames(psms)) {
		colnames(psms)[colnames(psms)=="Sequence"] <- "Annotated.Sequence"
	}

	if (length(sampleOrder)==0) {
		# make dummy sampleOrder
		sampleOrder <- data.frame(file=sort(unique(psms$SpectrumFileName)), stringsAsFactors=FALSE)
		sampleOrder <- data.frame(sampleOrder, shortName=sampleOrder$file, position=1:nrow(sampleOrder), stringsAsFactors=FALSE)
	}
	else {
		sampleOrder <- data.frame(file=sampleOrder, shortName=names(sampleOrder), position=1:length(sampleOrder), stringsAsFactors=FALSE)
	}
	sampleOrder$position <- as.numeric(sampleOrder$position)
	sampleOrder$file <- as.character(sampleOrder$file)
	sampleOrder <- sampleOrder[order(sampleOrder$position),]

	sampleOrder$file <- gsub(".raw", "", sampleOrder$file, fixed=TRUE)
	psms$SpectrumFileName <- gsub(".raw", "", psms$SpectrumFileName, fixed=TRUE)
	psms$SpectrumFileName <- as.factor(psms$SpectrumFileName)
	if (mean(psms$SpectrumFileName %in% sampleOrder$file)>0.5) {
		# # add raw to the SpectrumFile in case the name is different in psms
		# notInPsms <- !(sampleOrder$file %in% unique(psms$SpectrumFileName))
		# sampleOrder$file[notInPsms] <- paste(sampleOrder$file[notInPsms], ".raw", sep="")
		# problem: added .raw even if there was no PSMs, searching for wrong file

		# # # if there is more psms with .raw at the end at .raw at the end
		# # fnt <- table(psms$SpectrumFileName)
		# # lapply(1:nrow(sampleOrder), function(soix) { fnt[sampleOrder$file[soix]] })
		
		psms$SpectrumFileName <- factor(psms$SpectrumFileName, levels(psms$SpectrumFileName)[unlist(lapply(as.character(sampleOrder$file), function(l) { which(levels(psms$SpectrumFileName)==l) }))])
	}
	psms <- psms[!is.na(psms$SpectrumFileName),]

	spectrumInfo <- dbReadTable(pdResConn, "MSnSpectrumInfo")
	spectrumInfo$SpectrumFileName <- gsub(".raw", "", spectrumInfo$SpectrumFileName, fixed=TRUE)
	if (!is.factor(spectrumInfo$SpectrumFileName)) {
		spectrumInfo$SpectrumFileName <- as.factor(spectrumInfo$SpectrumFileName)
	}
	if (mean(spectrumInfo$SpectrumFileName %in% sampleOrder$file)>0.5) {
		spectrumInfo$SpectrumFileName <- factor(spectrumInfo$SpectrumFileName, levels(spectrumInfo$SpectrumFileName)[unlist(lapply(as.character(sampleOrder$file), function(l) { which(levels(spectrumInfo$SpectrumFileName)==l) }))])
		spectrumInfo <- spectrumInfo[!is.na(spectrumInfo$SpectrumFileName),]
	}
	
	vars <- sort(ls(globalenv()))

	checkCols <- function(reqCols, cols, doPlot=TRUE) {
		ret <- mean(reqCols %in% cols)>0.999
		if (!ret) {
			if (doPlot) {
				plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
				text(1, 0, paste("This plot requires column ", reqCols[!(reqCols %in% cols)]), col="red", cex=2)
			}
		}
		ret
	}

	nSamples <- length(unique(psms$SpectrumFileName))
	#nPlots <- 15
	nPlots1 <- 8
	nPlots2 <- 7
	cexNames <- 2
	longestFnameLen <- max(nchar(as.character(unique(psms$SpectrumFileName))))
	if (longestFnameLen>55) {
		cexNames <- 110/longestFnameLen
	}

	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_1.png", sep=""), width=1400, height=nPlots1*(180+20*nSamples))
	#png(pngFileName, width=1400, height=nPlots*(180+20*nSamples))
	par(mfrow=c(nPlots1,1))
	
	if (checkCols(c("DeltaMassInPPM", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		boxplot(psms$DeltaMassInPPM ~ psms$SpectrumFileName, horizontal=TRUE, ylim=c(-10,10), xlab="delta mass [ppm]", xlim=c(nSamples+0.7,0.3), main="mass deviation", cex.axis=2, cex.lab=2, cex.main=2, cex=2, yaxt="n")
		axis(2, cex.axis=cexNames, labels=levels(psms$SpectrumFileName), at=1:length(levels(psms$SpectrumFileName)))
		abline(v=0, lty=3)
	}

	if (checkCols(c("MissedCleavages", "Annotated.Sequence", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		barplot(rev(100*unlist(as.list(by(psms[,c("MissedCleavages", "Annotated.Sequence"), drop=FALSE], list(f=psms$SpectrumFileName), function(s) { mclPeps <- tapply(s$MissedCleavages, s$Annotated.Sequence, mean); mean(mclPeps>0, na.rm=TRUE) })))), horiz=TRUE, xlim=c(0,100), xlab="peptides with missed cleavage [%]", main="miscleaved peptides", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
		barplot(rev(100*unlist(as.list(by(psms[,c("MissedCleavages", "Annotated.Sequence"), drop=FALSE], list(f=psms$SpectrumFileName), function(s) { mclPeps <- tapply(s$MissedCleavages, s$Annotated.Sequence, mean); mean(mclPeps>1, na.rm=TRUE) })))), horiz=TRUE, col="black", add=TRUE, yaxt="n", xaxt="n")
		legend("topright", c("1 missed cleavage", "> 1"), fill=c("grey", "black"), cex=2)
	}

	if (checkCols(c("FirstScan", "SpectrumFileName"), colnames(spectrumInfo))) {
		if (checkCols(c("FirstScan", "SpectrumFileName"), colnames(psms))) {
			idRate <- merge(x=as.matrix(by(psms$FirstScan, list(f=psms$SpectrumFileName), length)), y=as.matrix(by(spectrumInfo$FirstScan, list(f=spectrumInfo$SpectrumFileName), function(x) { length(unique(x)) })), by="row.names", all=TRUE)
			idRate[is.na(idRate[,2, drop=FALSE]),2] <- 0
			rownames(idRate) <- idRate$Row.names
			idRate <- idRate[,-which(colnames(idRate)=="Row.names"), drop=FALSE]
			idRate <- data.frame(idRate, idr=idRate[,1]/idRate[,2],stringsAsFactors=FALSE)
			if (mean(rownames(idRate) %in% sampleOrder$file)>0.5) {
				idRate <- idRate[rev(sampleOrder$file),]
			}
			par(mar=c(5,75,7,2))
			barplot(100*idRate[,"idr"], names=rownames(idRate), horiz=TRUE, xlim=c(0,100), xlab="identified spectra [%]", main="id rate", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
		}
	}

	runCols <- rainbow(length(unique(psms$SpectrumFileName)))
	if (checkCols(c("SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		barplot(rev(table(psms$SpectrumFileName)), horiz=TRUE, xlab="#PSMs", main="identified spectra", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, col=rev(runCols))
	}
	
	if (checkCols(c("Charge", "SpectrumFileName"), colnames(spectrumInfo))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		tmp <- table(spectrumInfo[,c("Charge", "SpectrumFileName")])
		barplot(tmp[,rev(1:ncol(tmp))], beside=TRUE, horiz=TRUE, xlab="# spectra", main="charge state distribution", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, legend.text=TRUE, args.legend=c(cex=2), xlim=c(0,1.1*max(tmp)))
	}

	if (checkCols(c("MS2Errorppm", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		boxplot(psms$MS2Errorppm ~ psms$SpectrumFileName, horizontal=TRUE, ylim=c(0,30), xlab="MS2 Error [ppm]", xlim=c(nSamples+0.7,0.3), main="MS2 Error", cex.axis=2, cex.lab=2, cex.main=2, cex=2, yaxt="n")
		axis(2, cex.axis=cexNames, labels=levels(psms$SpectrumFileName), at=1:length(levels(psms$SpectrumFileName)))
	}
	
	if (checkCols(c("Modifications", "Annotated.Sequence", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		barplot(rev(100*unlist(as.list(by(psms[,c("Annotated.Sequence", "Modifications"), drop=FALSE], list(f=psms$SpectrumFileName), function(fPsms) { ms <- sum(unlist(lapply(gregexpr("[mM]", fPsms$Annotated.Sequence), function(x) { length(x[x>0]) }))); oxM <- sum(unlist(lapply(gregexpr("M\\d+\\(Oxidation\\)", fPsms$Modifications, perl=TRUE), function(x) { length(x[x>0]) }))); oxM/ms })))), horiz=TRUE, xlim=c(0,100), xlab="oxidised methionines [%] - PSM level", main="methionine oxidation", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
	}

	if (checkCols(c("Modifications", "Annotated.Sequence", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		barplot(rev(100*unlist(as.list(by(psms[,c("Annotated.Sequence", "Modifications"), drop=FALSE], list(f=psms$SpectrumFileName), function(fPsms) { nqs <- sum(unlist(lapply(gregexpr("[nNqQ]", fPsms$Annotated.Sequence), function(x) { length(x[x>0]) }))); deam <- sum(unlist(lapply(gregexpr("[NQ]\\d+\\(Deamidated\\)", fPsms$Modifications, perl=TRUE), function(x) { length(x[x>0]) }))); deam/nqs })))), horiz=TRUE, xlim=c(0,100), xlab="deamidated N/Q [%] - PSM level", main="deamidation", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
	}
	dev.off()
	
	
# second plot which does not scale with number of raw files	
	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_2.png", sep=""), width=1400, height=nPlots2*500)
	#png(pngFileName, width=1400, height=nPlots*(180+20*nSamples))
	par(mfrow=c(nPlots2,1))
	
	if (checkCols(c("Modifications", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		ms <- data.frame(modi="n")
		rfs <- as.character(unique(psms$SpectrumFileName))
		lapply(rfs, function(rf) { msf <- as.data.frame(table(gsub("\\)", "", gsub("^[^\\(]*\\(", "", unlist(strsplit(psms$Modifications[psms$SpectrumFileName==rf], "; "))))), stringsAsFactors=FALSE); msf <- rbind(data.frame(Var1=c("n"), Freq=0, stringsAsFactors=FALSE), msf); colnames(msf) <- c("modi", rf); ms <<- merge(ms, msf, all=TRUE, by="modi"); NULL })
		rownames(ms) <- ms$modi
		ms <- ms[(!(ms$modi=="n")),(!(colnames(ms)=="modi")),drop=FALSE]
		ms[is.na(ms)] <- 0
		ms <- ms[order(apply(ms, 1, max)),rev(1:ncol(ms)),drop=FALSE]
		ms <- ms[!grepl("^TMT", rownames(ms)),,drop=FALSE]
		ms <- ms[(!(rownames(ms) %in% c("Oxidation", "Methylthio", "Carbamidomethyl", "Deamidated"))),,drop=FALSE]
		if (sum(nchar(rownames(ms)))>70) {
			rownames(ms) <- substr(rownames(ms), 1, 6)
		}
		if (nrow(ms)>0) {
			barplot(as.matrix(t(ms)), beside=TRUE, col=runCols, main="other modifications",	cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
		}
		else {
			plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
			text(1, 0, "no modifications found", col="red", cex=2)
		}
	}

	if (checkCols(c("AmandaScore", "SpectrumFileName"), colnames(psms))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		scoreDist <- tapply(psms$AmandaScore, psms$SpectrumFileName, density, bw=5)
		plot(0, type="n", xlim=range(psms$AmandaScore), ylim=c(0, max(unlist(lapply(scoreDist, function(d) { d[["y"]]*d[["n"]] })))), xlab="Amanda Score", ylab="", yaxt="n", main="score distribution", cex.axis=2, cex.main=2, cex.lab=2)
		unlist(lapply(1:length(scoreDist), function(sdIx) { d <- scoreDist[[sdIx]]; lines(d[["x"]], d[["y"]]*d[["n"]], col=runCols[sdIx]); NULL }))
	}

	if (checkCols(c("RetentionTime", "SpectrumFileName"), colnames(spectrumInfo))) {
		if (checkCols(c("RetentionTime", "SpectrumFileName"), colnames(psms))) {
			groupMins <- 2
			psmsPmin <- tapply(psms$RetentionTime, psms$SpectrumFileName, function(rts) {
				ret <- as.data.frame(table(round(rts/groupMins, 0))/groupMins, stringsAsFactors=FALSE)
				colnames(ret) <- c("t", "nPsms")
				ret$t <- as.numeric(ret$t)
				ret
			})
			par(mar=c(5,75,7,2))
			plot(0, type="n", xlim=range(spectrumInfo$RetentionTime), ylim=c(0, max(unlist(lapply(psmsPmin, function(ppm) { max(ppm[,"nPsms", drop=FALSE]) })))), xlab="retention time [min]", ylab="", main="id speed", cex.axis=2, cex.main=2, cex.lab=2)
			# mtext("PSMs/min", 2, 4, cex=2)
			title(ylab="PSMs/min", cex.lab=2, line=5)
			unlist(lapply(1:length(psmsPmin), function(ppmIx) { ppm <- psmsPmin[[ppmIx]]; lines(groupMins*t(ppm[,"t", drop=FALSE]), t(ppm[,"nPsms", drop=FALSE]), col=runCols[ppmIx]); NULL }))
		}
	}

	if (checkCols(c("OriginalPrecursorMass", "SpectrumFileName"), colnames(spectrumInfo))) {
		par(las=1)
		par(mar=c(5,75,7,2))
		precDist <- tapply(spectrumInfo$OriginalPrecursorMass, spectrumInfo$SpectrumFileName, density, bw=5)
		plot(0, type="n", xlim=range(spectrumInfo$OriginalPrecursorMass), ylim=c(0, max(unlist(lapply(precDist, function(d) { d[["y"]]*d[["n"]] })))), xlab="m/z [Th]", ylab="", yaxt="n", main="precursor distribution", cex.axis=2, cex.main=2, cex.lab=2)
		unlist(lapply(1:length(precDist), function(pdIx) { pd <- precDist[[pdIx]]; lines(pd[["x"]], pd[["y"]]*pd[["n"]], col=runCols[pdIx]); NULL }))
	}

	if (checkCols(c("SearchSpace", "SpectrumFileName"), colnames(psms))) {
		searchSpace <- tapply(psms$SearchSpace, psms$SpectrumFileName, sort)
		par(mar=c(5,75,7,2))
		plot(0, type="n", xlim=c(0,max(unlist(lapply(searchSpace, length)))), ylim=c(0,max(unlist(searchSpace, max))), xlab="PSMs", ylab="", main="search space", cex.axis=2, cex.main=2, cex.lab=2)
		# mtext("search space", 2, 4, cex=2)
		title(ylab="search space", cex.lab=2, line=5)
		unlist(lapply(1:length(searchSpace), function(ix) { lines(searchSpace[[ix]], col=runCols[ix]) }))
	}
	
	quanResNFoundMsg <- ""
	cat("querying for data of new apQuant version\n")
	r <- try(quanRes <- dbGetQuery(pdResConn, "SELECT * FROM aQQuanResults WHERE Confidence>1;"), silent=TRUE)
	if (class(r)=="try-error") {
		cat("querying for data of old apQuant version\n")
		# support for Peakjuggler (old)
		r <- try(quanRes <- dbGetQuery(pdResConn, "SELECT * FROM PjQuanResults WHERE Confidence>1;"), silent=TRUE)
	}
	if (!(class(r)=="try-error")) {
		cat("apQuant data successfully queried\n")
		if ("quanRes" %in% ls()) {
			if (nrow(quanRes)>0) {
				quanCols <- gsub("%", "", gsub("µ", "", gsub("\\.", "", gsub(".raw", "", sampleOrder$file[order(sampleOrder$position)], fixed=TRUE))), fixed=TRUE)
				if (checkCols(c("apQuantAreas"), colnames(quanRes), doPlot=FALSE)) {
					chNames <- dbGetQuery(pdResConn, "SELECT Name FROM DataDistributionBoxes WHERE DataDistributionMapID=(SELECT SpecialValueTypeID FROM DataTypesColumns WHERE DBColumnName='apQuantAreas' AND SpecialValueType='DataDistribution' AND DataTypeID=(SELECT DataTypeID FROM DataTypes WHERE TableName='aQQuanResults')) ORDER BY Position;")[,1]
					#quanCols <- chNames # might be wrong sample order
					if (length(chNames)>0) {
						qrWab <- which(unlist(lapply(quanRes[,"apQuantAreas"], function(x) { length(unlist(x)) }))==(9*length(chNames)))
						if (length(qrWab)>1) {
							cat("found data of new apQuant version\n")
							quanRes <- do.call("rbind", lapply(quanRes[qrWab,"apQuantAreas"], function(d) {
								d <- unlist(d)
								unlist(lapply(1:length(chNames), function(chIx) {
									BytesToDouble(d[1:8+(chIx-1)*9])
								}))
							} ))
							colnames(quanRes) <- chNames
						}
						else {
							quanResNFoundMsg <- "apQuant: blob size does not fit nr of samples"
						}
					}
					else {
						quanResNFoundMsg <- "apQuant: no sample columns found"
					}
				}
				else {
					colnames(quanRes) <- gsub("raw$", "", colnames(quanRes))
					if (!(sum(quanCols %in% colnames(quanRes))>0)) {
						quanResNFoundMsg <- "apQuant: could not find quantitative information for raw files"
					}
				}
			}
			else {
				quanResNFoundMsg <- "apQuant: no quantitative data found"
			}
		}
		else {
			quanResNFoundMsg <- "apQuant: could not query quantitative data"
		}
	}
	else {
		if (checkCols(c("Abundances"), colnames(psms), doPlot=FALSE)) {
			cat("querying for TMT channels\n")
			chNames <- dbGetQuery(pdResConn, "SELECT Name FROM DataDistributionBoxes WHERE DataDistributionMapID=(SELECT SpecialValueTypeID FROM DataTypesColumns WHERE DBColumnName='Abundances' AND SpecialValueType='DataDistribution' AND DataTypeID=(SELECT DataTypeID FROM DataTypes WHERE TableName='TargetPsms')) ORDER BY Position;")[,1]
			#quanCols <- rev(chNames) # might be wrong sample order
			quanCols <- chNames
			if (length(chNames)>0) {
				psmsWab <- which(unlist(lapply(psms[,"Abundances"], function(x) { length(unlist(x)) }))==(9*length(chNames)))
				if (length(psmsWab)>1) {
					cat("TMT data found\n")
					quanRes <- do.call("rbind", lapply(psms[psmsWab,"Abundances"], function(d) {
						d <- unlist(d)
						unlist(lapply(1:length(chNames), function(chIx) {
							BytesToDouble(d[1:8+(chIx-1)*9])
						}))
					} ))
					colnames(quanRes) <- chNames
				}
				else {
					quanResNFoundMsg <- "TMT: blob size does not fit nr of TMT channels"
				}
			}
			else {
				quanResNFoundMsg <- "TMT: no TMT channels found"
			}
		}
		else {
			
			quanResNFoundMsg <- "TMT: could not find column Abundances"
		}
	}
	# remove samples not checked in (/passed on) from MS2Go
	if (sum(sampleOrder$file %in% colnames(quanRes))>0) {
		quanRes <- quanRes[,sampleOrder$file,drop=FALSE]
	}
	
	#check if number of names fits to number of columns (apQuant grouping), otherwise skip renaming
	if (ncol(quanRes)==nrow(sampleOrder)) {
		# rename quan columns according to renaming in MS2Go GUI
		colnames(quanRes)[unlist(lapply(quanCols, function(cn) { which(colnames(quanRes)==cn) }))] <- sampleOrder$shortName
		quanCols <- rev(sampleOrder$shortName)
	}
	else {
		cat("!number of samples in MS2Go does not fit number of quantified samples!\n-> plotting raw files\n")
		quanCols <- rev(colnames(quanRes))
	}
	if (quanResNFoundMsg=="") {
		d <- quanRes[,quanCols,drop=FALSE] # !!! don't change column order -> names
		par(mar=c(5,75,7,2))
		barplot(apply(d>0, 2, sum, na.rm=TRUE), names=gsub("\\.raw$", "", quanCols), horiz=TRUE, xlim=c(0,nrow(quanRes)), xlab="# quantified features", main="quantified features", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
	}
	else {
		plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
		text(1, 0, quanResNFoundMsg, col="red", cex=2)
	}

	if (quanResNFoundMsg=="") {
		if (deInst) {
			d <- quanRes[,rev(quanCols),drop=FALSE]
			if (ncol(d)>1) {
				d <- log10(d)
				d[abs(d)>9e99] <- NA
				# colnames(d) <- gsub("File", "", gsub("raw$", "", unlist(lapply(colnames(d), function(n) { substr(n, nchar(n)-50, nchar(n)) }))))
				colnames(d) <- gsub("File", "", gsub("\\.raw$", "", colnames(d)))
				par(mar=c(3,37,4,1))
				s <- par()[["cex"]]
				par(cex=0.7*cexNames)
				cm <- cor(d, use="pairwise.complete.obs")
				cm[is.na(cm)] <- 0
				dend <- as.dendrogram(hclust(as.dist(1-cm)))
				plot_horiz.dendrogram(dend, side=TRUE)
				par(cex=s)
			}
			else {
				plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
				text(1, 0, "dendrogram requires multiple samples", col="red", cex=2)
			}
		}
		else {
			plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
			text(1, 0, "could not load package \"dendextend\"", col="red", cex=2)
		}
	}
	else {
		plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
		text(1, 0, quanResNFoundMsg, col="red", cex=2)
	}
	

# # trying other approach for dendrogram (distance based on log intensities, not on correlation)
# # made results worse on: 20190529_QExHFX1_RSLC1_Dagdas_Dagdas_GMI_onbead_ATG8a_peptide_40perc_sample_11-18_Set2_mpoly_Step2.pdResult
	# if (quanResNFoundMsg=="") {
		# if (deInst) {
			# d <- quanRes[,quanCols,drop=FALSE]
			# if (ncol(d)>1) {
				# d <- log10(d)
				# d[abs(d)>9e99] <- NA
				# ## only top abundant peptides
				# #d <- d[rev(order(apply(d, 1, sum, na.rm=TRUE)))[1:round(nrow(d)/2, 0)],]
				# ## impute missing peptides
				# #d[is.na(d)] <- quantile(d, 0.05, na.rm=TRUE)
				
				# colnames(d) <- gsub("File", "", gsub("raw$", "", colnames(d)))
				# par(mar=c(3,37,4,1))
				# s <- par()[["cex"]]
				# par(cex=0.7*cexNames)
				# plot_horiz.dendrogram(as.dendrogram(hclust(dist(t(d)))), side=TRUE)
				# par(cex=s)
			# }
			# else {
				# plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
				# text(1, 0, "dendrogram requires multiple samples", col="red", cex=2)
			# }
		# }
		# else {
			# plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
			# text(1, 0, "could not load package \"dendextend\"", col="red", cex=2)
		# }
	# }
	# else {
		# plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
		# text(1, 0, quanResNFoundMsg, col="red", cex=2)
	# }

	dev.off()
	
	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_pca.png", sep=""), width=1400, height=900)
	plot(0, bty="n", xaxt="n", yaxt="n", xlab="", ylab="", type="n")
	if (quanResNFoundMsg=="") {
		if ("cm" %in% ls()) {
			# pcs <- principal(cm, 2)
			# pcls <- pcs$loadings[,1:2]
			# plot(pcs, xlim=c(min(pcls[,1]), max(pcls[,1])+(0.5*(max(pcls[,1])-min(pcls[,1])))))
			# legend("topright", paste(1:nrow(pcls), substr(rownames(pcls), pmax(1,nchar(rownames(pcls))-50), nchar(rownames(pcls))), sep=": "))
			pcs <- princomp(cm)
			pcls <- pcs$loadings[,1:2]
			plot(pcls, xlim=c(min(pcls[,1]), max(pcls[,1])+(0.5*(max(pcls[,1])-min(pcls[,1])))), col=runCols, pch=1:nrow(pcls))
			unlist(lapply(1:nrow(pcls), function(ix) { text(pcls[ix,1], pcls[ix,2], ix, pos=4) }))
			legend("topright", paste(1:nrow(pcls), substr(rownames(pcls), pmax(1,nchar(rownames(pcls))-50), nchar(rownames(pcls))), sep=": "), pch=1:nrow(pcls), col=runCols)
		}
		else {
			text(1, 0, "could not find correlation matrix", col="red", cex=2)
		}
	}
	else {
		text(1, 0, quanResNFoundMsg, col="red", cex=2)
	}
	dev.off()

# !!! fraction of missing quan values per file on protein/peptide level !!!
# make heatmap for other modis
## include ms2 mass deviation if available
# fraction of PSMs identified by first/second search and clustering ~ ID rate
## cumulative search space curve (all files in one plot)
## precursor m/z distributaion (all files in one plot)
## quan value correlation matrix to see replicates (color and scatter plot on triangles)
# see Ottos suggestions (mail/youtrack)
# see plots from Zuerich (pdf in this folder)

# correlation of quan results between runs
# advantage:
# - no decoding of doubles required, as in PJ protein areas
# - runs are not combined into samples
	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_corr.png", sep=""), width=1700, height=1700)
	plot(0, bty="n", xaxt="n", yaxt="n", xlab="", ylab="", type="n")
	if (quanResNFoundMsg=="") {
		d <- quanRes[,rev(quanCols),drop=FALSE]
		if (ncol(d)>1) {
			# remove samples without quantified peptides
			d <- d[,apply(d, 2, function(x) { sum(x>0, na.rm=TRUE) })>0]
			# colnames(d) <- gsub("^.{70}", "", quanCols)
			# plot(log10(d))
			# samples have the same order from top to bottom
			suffixLen <- 43
			if (ncol(d)>6) { suffixLen <- 35 }
			if (ncol(d)>10) { suffixLen <- 23 }
			d <- log10(d)
			d[abs(d)>9e99] <- NA
			colnames(d) <- gsub("\\.raw$", "", unlist(lapply(colnames(d), function(n) { substr(n, nchar(n)-suffixLen, nchar(n)) })))
			colnames(d) <- gsub("File", "", gsub("raw$", "", colnames(d)))
			pairs.panels(d, hist.col="white", ellipses=FALSE, rug=FALSE, smooth=FALSE)
		} 
		else {
#			plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
			text(1, 0, "correlation plot requires multiple samples", col="red", cex=2)
		}
	}
	else {
#		plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
		text(1, 0, quanResNFoundMsg, col="red", cex=2)
	}
	dev.off()

	
	dbDisconnect(pdResConn)
	dbDisconnect(pdResViewConn)
	NULL
}
